// PerfQueue.cpp starts
// CGP, 12/20/00

#include "PerfQueue.h"

PerfQueue::PerfQueue(int size) : maxLength(size)
{
  queue = new int[maxLength];
  numberItems = 0;
  itemIndex = 0;
}

PerfQueue::~PerfQueue()
{
	delete [] queue;
}

// We are never dequeueing from the queue, so we can just sum
// up to the numberItems items in the array
int PerfQueue::Performance()
{
  int n = 0;
  
  for (int i=0; i < numberItems; i++) {
    n += queue[i];
  }
  
  return n;
}

void PerfQueue::Enqueue(int item)
{
  queue[itemIndex] = item;
  itemIndex = (itemIndex + 1) % maxLength;
  
  numberItems++;
  if (numberItems > maxLength) {
    numberItems = maxLength;
  }
}

int PerfQueue::CurrLength()
{
  return numberItems;
}

void PerfQueue::Reset()
{
	numberItems = 0;
	itemIndex = 0;
}

// PerfQueue.cpp ends